implementation module Window1;

import	StdInt, StdBool, StdString, StdFile;
import	windows, quickdraw,pointer;
import	Window2, commonDef, windowDevice, windowAccess,ScrollBars;
from	deltaPicture	import EraseRectangle;
from	dialogAccess	import IOStateModalDialogActive;
::	DeltaWindowHandle	*s		:== (WindowHandle s) -> *Toolbox -> *(! WindowHandle s,  !*Toolbox);
::	DeltaWindowHandles	*s		:== [WindowHandle s] -> *Toolbox -> *(![WindowHandle s], !*Toolbox);
::	DeltaWindowDef		*s *io	:== (WindowDef s io) -> WindowDef s io;

WindowIdOK :: WindowId -> Bool;
WindowIdOK _ = True;

ChangeWindows :: !(DeltaWindowHandles s) !(IOState s) -> IOState s;
ChangeWindows f ioState
	= 	IOStateSetDevice (IOStateSetToolbox tb1 ioState2) windows1;
	where {
		(windows,	ioState1)	= IOStateGetDevice  ioState WindowDevice;
		(tb,		ioState2)	= IOStateGetToolbox ioState1;
		(wHs,		cursor)		= WindowSystemState_WindowHandles windows;
		(wHs1,		tb1)		= f wHs tb;
		windows1				= WindowSystemState (wHs1, cursor);
	};

ChangeWindow :: !(Cond WindowId) !(DeltaWindowHandle s) !(IOState s) -> IOState s;
ChangeWindow cond f ioState = ChangeWindows (ChangeWindowHandles cond f) ioState;

ChangeWindowHandles :: !(Cond WindowId) !(DeltaWindowHandle s) ![WindowHandle s] !*Toolbox
		->	(![WindowHandle s],!*Toolbox);
ChangeWindowHandles cond f [wH=:(wDef, window) : wHs] tb
|	cond (WindowDefGetWindowId wDef)	= ([wH1 : wHs ], tb1);
										= ([wH  : wHs1], tb2);
	where {
		(wH1,  tb1) = f wH tb;
		(wHs1, tb2) = ChangeWindowHandles cond f wHs tb;
	};
ChangeWindowHandles _ _ wHs tb = (wHs, tb);


/*	Changing the (active) WindowTitle:
*/

ChangeWindowTitle :: !WindowId !WindowTitle !(IOState s) -> IOState s;
ChangeWindowTitle id title ioState
	= 	ChangeWindow ((==) id) (WindowHandleSetTitle title) ioState;

ChangeActiveWindowTitle :: !WindowTitle !(IOState s) -> IOState s;
ChangeActiveWindowTitle title ioState
	= 	ChangeWindow WindowIdOK (WindowHandleSetTitle title) ioState;

WindowHandleSetTitle :: !WindowTitle !(WindowHandle s) !*Toolbox -> (!WindowHandle s, !*Toolbox);
WindowHandleSetTitle title wH=:(_,(wPtr,_,_,_,_,_)) tb = (wH, SetWTitle wPtr title tb);


/*	Changing the (active) UpdateFunction:
*/

ChangeUpdateFunction :: !WindowId !(UpdateFunction s) !(IOState s) -> IOState s;
ChangeUpdateFunction id updateF ioState
	= 	ChangeWindow ((==) id) (ChangeWindowDef (WindowDefSetUpdate (Update_new updateF))) ioState;

ChangeActiveUpdateFunction :: !(UpdateFunction s) !(IOState s) -> IOState s;
ChangeActiveUpdateFunction updateF ioState
	= 	ChangeWindow WindowIdOK (ChangeWindowDef (WindowDefSetUpdate (Update_new updateF))) ioState;

Update_new :: !(UpdateFunction *s) !UpdateArea *s -> (!*s, ![DrawFunction]);
Update_new updateF updArea s
	= 	(s`, [EraseUpdArea updArea : fs]);
	where {
		(s`, fs)= updateF updArea s;
	};

EraseUpdArea :: !UpdateArea !Picture -> Picture;
EraseUpdArea [rect : rects] picture =  EraseUpdArea rects (EraseRectangle rect picture);
EraseUpdArea rects picture =  picture;


/*	Change the local CursorShape of the (active) window.
*/

ChangeWindowCursor :: !WindowId !CursorShape !(IOState s) -> IOState s;
ChangeWindowCursor id shape ioState =  ChangeCursor ((==) id) shape ioState;

ChangeActiveWindowCursor :: !CursorShape !(IOState s) -> IOState s;
ChangeActiveWindowCursor shape ioState =  ChangeCursor WindowIdOK shape ioState;

ChangeCursor :: !(Cond WindowId) !CursorShape !(IOState s) -> IOState s;
ChangeCursor cond shape ioState
|	not exists			= ioState1;
|	not (cond activeId)	= ioState2;
						= SetRightCursorShape shape ioState2;
	where {
		f								= ChangeWindowDef (WindowDefSetCursor shape);
		(exists, activeId, ioState1)	= GetActiveWindow ioState;
		ioState2						= ChangeWindow cond f ioState1;
	};

SetRightCursorShape :: !CursorShape !(IOState s) -> IOState s;
SetRightCursorShape shape ioState
|	globalSet || not inFrame	= ioState1;
								= IOStateSetCursorShape shape ioState1;
	where {
		(globalSet, inFrame, wPtr, ioState1)= IOStateGetCursorPos ioState;
	};

//	Opening windows:

OpenWindows :: ![WindowDef s (IOState s)] !(IOState s) -> IOState s;
OpenWindows wDefs ioState
	| IsEmptyList wDefs	= ioState;
						= ChangeWindows (Open_windows behind wDefs) ioState1;
	where {
		(b, behind, ioState1) = IOStateModalDialogActive ioState;
	};	
			
//	Closing windows:

CloseWindows :: ![WindowId] !(IOState s) -> IOState s;
CloseWindows ids ioState
|	IsEmptyList ids	= ioState;
					= ChangeWindows (CloseWindowHandles ids) ioState;

CloseActiveWindow :: !(IOState s) -> IOState s;
CloseActiveWindow ioState = ChangeWindows (CloseWindowHandle WindowIdOK) ioState;

CloseWindowHandles :: ![WindowId] ![WindowHandle s] !*Toolbox -> (![WindowHandle s], !*Toolbox);
CloseWindowHandles [id : ids] wHs tb
	= 	CloseWindowHandles ids wHs1 tb1;
	where {
		(wHs1, tb1) = CloseWindowHandle ((==) id) wHs tb;
	};
CloseWindowHandles ids wHs tb = (wHs, tb);

CloseWindowHandle :: !(Cond WindowId) ![WindowHandle s] !*Toolbox -> (![WindowHandle s], !*Toolbox);
CloseWindowHandle cond [wH=:(wDef, window) : wHs] tb
|	not (cond (WindowDefGetWindowId wDef))	= ([wH : wHs1], tb1);
											= (wHs, DisposeWindow (WindowGetPtr window) tb);
	where {
		(wHs1, tb1) = CloseWindowHandle cond wHs tb;
	};
CloseWindowHandle cond wHs tb = (wHs, tb);


//	Making a window the active window:

ActivateWindow :: !WindowId !(IOState s) -> IOState s;
ActivateWindow id ioState
|	modalDialogOpen		= ioState1;
						= ChangeWindows (ActivateWindowHandle id) ioState1;
	where {
		(modalDialogOpen, p, ioState1) = IOStateModalDialogActive ioState;
	};

ActivateWindowHandle :: !WindowId ![WindowHandle s] !*Toolbox -> (![WindowHandle s], !*Toolbox);
ActivateWindowHandle id wHs tb
	| found
		= ([(wDef,(wPtr, hBar, vBar, pict, updArea1, zoom)) : wHs1], tb11);
		{
			(wPtr, hBar, vBar, pict, updArea, zoom) = window;
			(wDef, window)							= wH;
			tb1					= SelectWindow wPtr tb;
			(updRgn,	tb2)	= LoadLong (wPtr + WindowPtrupdateRgn) tb1;
			(updRgnRect,tb3)	= LoadLong updRgn tb2;
			rect				= 2 + updRgnRect;
			(top,		tb4)	= LoadWord rect			tb3;
			(left,		tb5)	= LoadWord (rect + 2)	tb4;
			(bottom,	tb6)	= LoadWord (rect + 4)	tb5;
			(right,		tb7)	= LoadWord (rect + 6)	tb6;
			(hControl,_,vMax)	= hBar;
			(vControl,_,hMax)	= vBar;
			(vThumb,	tb8)	= GetScrollBarValue vControl vMax tb7;
			(hThumb, 	tb9)	= GetScrollBarValue hControl hMax tb8;
			(locMax, 	tb10)	= InGrafport wPtr (GlobalToLocal (right,bottom)) tb9;
			(locMin, 	tb11)	= InGrafport wPtr (GlobalToLocal (left, top)) tb10;
			(locLeft,  locTop)	= locMin;
			(locRight, locBot)	= locMax;
			updArea1			= if (locLeft==locRight || locTop==locBot)
										updArea 
										[((hThumb + locLeft, vThumb + locTop),
										 (hThumb  + locRight,vThumb + locBot))];
		}
		= (wHs, tb);
	where {
		(found, wH, wHs1)	= Remove (EqualWindowHandleId id) (DummyWindowHandle 0) wHs;		
	};

WindowPtrupdateRgn :== 122;

EqualWindowHandleId :: !WindowId !(WindowHandle s) -> Bool;
EqualWindowHandleId id (wDef, window) = id == WindowDefGetWindowId wDef;

//	Drawing in (active) window:

DrawInWindow :: !WindowId ![DrawFunction] !(IOState s) -> IOState s;
DrawInWindow id fs ioState = ChangeWindow ((==) id) (DrawInWindowHandle fs) ioState;

DrawInActiveWindow :: ![DrawFunction] !(IOState s) -> IOState s;
DrawInActiveWindow fs ioState = ChangeWindow WindowIdOK (DrawInWindowHandle fs) ioState;

DrawInWindowHandle :: ![DrawFunction] !(WindowHandle s) !*Toolbox -> (!WindowHandle s, !*Toolbox);
DrawInWindowHandle fs (wDef, window) tb
	= 	((wDef, window1), tb1);
	where {
		(window1, tb1) = Draw_in_window window (WindowDefGetDrawMode wDef) fs tb;
	};


/*	Enabling and Disabling of the (active) WindowKeyboard attribute:
*/

EnableKeyboard :: !WindowId !(IOState s) -> IOState s;
EnableKeyboard id ioState
	= 	ChangeWindow ((==) id) (ChangeWindowDef (SetSelectKeyboard Able)) ioState;

DisableKeyboard :: !WindowId !(IOState s) -> IOState s;
DisableKeyboard id ioState
	= 	ChangeWindow ((==) id) (ChangeWindowDef (SetSelectKeyboard Unable)) ioState;

EnableActiveKeyboard :: !(IOState s) -> IOState s;
EnableActiveKeyboard ioState
	= 	ChangeWindow WindowIdOK (ChangeWindowDef (SetSelectKeyboard Able)) ioState;

DisableActiveKeyboard :: !(IOState s) -> IOState s;
DisableActiveKeyboard ioState
	= 	ChangeWindow WindowIdOK (ChangeWindowDef (SetSelectKeyboard Unable)) ioState;

ChangeWindowDef :: !(DeltaWindowDef s (IOState s)) !(WindowHandle s) *Toolbox -> (!WindowHandle s,*Toolbox);
ChangeWindowDef f (wDef, window) tb = ((f wDef, window), tb);

SetSelectKeyboard :: !SelectState !(WindowDef s (IOState s)) -> WindowDef s (IOState s);
SetSelectKeyboard select wDef
	= 	WindowDefSetKeyboard select kf wDef;
	where {
		(ks, kf) = WindowDefGetKeyboard wDef;
	};


/*	Changing the (active) KeyboardFunction:
*/

ChangeKeyboardFunction :: !WindowId !(KeyboardFunction s (IOState s)) !(IOState s) -> IOState s;
ChangeKeyboardFunction id f ioState
	= 	ChangeWindow ((==) id) (ChangeWindowDef (SetKeyboardFunction f)) ioState;

ChangeActiveKeyboardFunction :: !(KeyboardFunction s (IOState s)) !(IOState s) -> IOState s;
ChangeActiveKeyboardFunction f ioState
	= 	ChangeWindow WindowIdOK (ChangeWindowDef (SetKeyboardFunction f)) ioState;

SetKeyboardFunction :: !(KeyboardFunction s (IOState s)) !(WindowDef s (IOState s))
	->	  WindowDef s (IOState s);
SetKeyboardFunction f wDef
	= 	WindowDefSetKeyboard ks f wDef;
	where {
		(ks, kf)= WindowDefGetKeyboard wDef;
	};


/*	Enabling and Disabling of the (active) WindowMouse attribute:
*/

EnableMouse :: !WindowId !(IOState s) -> IOState s;
EnableMouse id ioState
	= 	ChangeWindow ((==) id) (ChangeWindowDef (SetSelectMouse Able)) ioState;

DisableMouse :: !WindowId !(IOState s) -> IOState s;
DisableMouse id ioState
	= 	ChangeWindow ((==) id) (ChangeWindowDef (SetSelectMouse Unable)) ioState;

EnableActiveMouse :: !(IOState s) -> IOState s;
EnableActiveMouse ioState
	= 	ChangeWindow WindowIdOK (ChangeWindowDef (SetSelectMouse Able)) ioState;

DisableActiveMouse :: !(IOState s) -> IOState s;
DisableActiveMouse ioState
	= 	ChangeWindow WindowIdOK (ChangeWindowDef (SetSelectMouse Unable)) ioState;

SetSelectMouse :: !SelectState !(WindowDef s (IOState s)) -> WindowDef s (IOState s);
SetSelectMouse select wDef
	= 	WindowDefSetMouse select mf wDef;
	where {
		(ms, mf)= WindowDefGetMouse wDef;
	};


/*	Changing the (active) MouseFunction:
*/

ChangeMouseFunction :: !WindowId !(MouseFunction s (IOState s)) !(IOState s) -> IOState s;
ChangeMouseFunction id f ioState
	= 	ChangeWindow ((==) id) (ChangeWindowDef (SetMouseFunction f)) ioState;

ChangeActiveMouseFunction :: !(MouseFunction s (IOState s)) !(IOState s) -> IOState s;
ChangeActiveMouseFunction f ioState
	= 	ChangeWindow WindowIdOK (ChangeWindowDef (SetMouseFunction f)) ioState;

SetMouseFunction :: !(MouseFunction s (IOState s)) !(WindowDef s (IOState s)) -> WindowDef s (IOState s);
SetMouseFunction f wDef
	= 	WindowDefSetMouse ms f wDef;
	where {
		(ms, mf)= WindowDefGetMouse wDef;
	};
